/*************************************************************************************
**	This script creates a complete listing of source/target products for all 
**	possible modfiications for every bloodproduct in VBECS. 
**	This does not included all pooling combinations however, it only
**	has targets for single source products.
**
**	It has been coded to help with the UnitTest build, and should be executed at
**	the end of the other database-creeating AutoBuild scripts.
**
**	The output is a Cross-Reference table named 'UnitTestModifications' that contains
**	the from/to bloodproductguids, producttypecodes, method, expiration times.
**	See below for table defintion. Do not revove columns.
**
**	Execution Time: Roughly 4 hours (1.6.0.5)
**
**	Output: 87176 Rows (1.6.0.5 pre-code-lock)
**
**	Created: 7/22/2011		Last Modified:  11/15/2011
**    
**	TODO: Add error handling/comments?
**      
**      Notes: Updated on 11/15/2011 - Performance improvment - removed nested CURSOR
**             New guestimate run time 2:22 hrs
**************************************************************************Lohse*******/
--For the AutoBuild process to work right...
USE @UT_DB_NAME@
GO

--Destroy all our tables if they already exist...
IF EXISTS (SELECT 1 FROM sysobjects WHERE [name] = 'UnitTestModifications')
	DROP TABLE UnitTestModifications

IF EXISTS (SELECT 1 FROM sysobjects WHERE [name] = 'GetTargetProducts_Temp')
	DROP TABLE GetTargetProducts_Temp

IF EXISTS (SELECT 1 FROM sysobjects WHERE [name] = 'ModificationSubset_Temp')
	DROP TABLE ModificationSubset_Temp


/**********************************************************************************
**
**	Our Ultimate Xref table that contains all BloodProduct modifications and Targets
**
**********************************************************************************/
CREATE TABLE UnitTestModifications 
( 
	[FromBloodProductGuid] [uniqueidentifier] NOT NULL , 
	[ToBloodProductGuid] [uniqueidentifier] NOT NULL , 
	[FromProductTypeCode] [char] (4) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL , 
	[ToProductTypeCode] [char] (4) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL , 
	[FromProductCodeIndicator] bit NOT NULL, 
	[ProductModificationCode] [char] (1) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL , 
	[ProductModificationMethod] [int] NOT NULL  
	CONSTRAINT [PK_UnitTestModifications] PRIMARY KEY  CLUSTERED 
	(
		[FromBloodProductGuid], 
		[ToBloodProductGuid], 
		[ProductModificationCode], 
		[ProductModificationMethod] 
	) ON [PRIMARY] 
) ON [PRIMARY] 

--The File should already have been copied over to SQLZ3
--The BulkFile was created on 6/20/2012 -- Update when there are TT changes!!!
BULK INSERT @UT_DB_NAME@.dbo.UnitTestModifications FROM '\\@GOLD_SERVER@\AutobuildFiles\UnitTestModificationsBulkLoad.txt' WITH( FIELDTERMINATOR = ',')

/*Commenting out the rest ---

/**********************************************************************************
**
**	Table to store what is basically the result of spGetTargetProducts calls
**
**********************************************************************************/
CREATE TABLE GetTargetProducts_Temp
( 
	[BloodProductGuid] [uniqueidentifier] NOT NULL , 
	[ComponentClassID] [int] NOT NULL , 
	[ProductCode] [char] (5) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL , 
	[ProductShortName] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL , 
	[ProductName] [varchar] (175) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL , 
	[ProductTypeCode] [char] (4) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL , 
	[ProductTypeName] [varchar] (60) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL , 
	[ProductVolume] [smallint] NOT NULL , 
	[MaximumStorageTime] [decimal] (9,0) NOT NULL , 
	[BarcodeType] [bit] NOT NULL , 
	[ProductActiveIndicator] [bit] NOT NULL , 
	[CodeAndShortName] [varchar] (60) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL , 
	[DivisionCode] [char] (5) NOT NULL , 
	[ExpirationDateRule] [int] NOT NULL , 
	[MethodSelect] [int] NOT NULL,
	[ProductModificationCode] CHAR (1) NOT NULL	--THIS IS MINE
	CONSTRAINT [PK_GetTargetProducts_Temp] PRIMARY KEY  CLUSTERED 
	(
		[BloodProductGuid], 
		[ProductCode], 
		[MethodSelect],
		[ProductModificationCode]
	) ON [PRIMARY] 
) ON [PRIMARY] 


/**********************************************************************************
**
**	Temporary tables that house the results of 
**	dbo.spSingleBloodProductModification and dbo.spBloodProductModificationPool calls
**
**********************************************************************************/
CREATE TABLE ModificationSubset_Temp 
(		ProductModificationCode CHAR(1),
		MethodSelect INTEGER,
		AddTargetAttribute VARCHAR(20),
		FromBloodProductGuid UNIQUEIDENTIFIER,
		FromProductTypeCode VARCHAR(4),
		FromProductCode VARCHAR(5),
		FromCoreCondition VARCHAR(3),
		FromProductAttributeForm VARCHAR(40),
		ToBloodProductGuid UNIQUEIDENTIFIER,
		ToProductTypeCode VARCHAR(4),
		ToProductCode VARCHAR(5),
		ToCoreCondition VARCHAR(3),
		ToProductAttributeForm VARCHAR(40),
		ExpirationDateRule INTEGER
)



--Grab all the blood products
DECLARE @fromBPGuidChar VARCHAR(40)
DECLARE @fromBPGuid UNIQUEIDENTIFIER
DECLARE @fromProductTypeCode CHAR(4)
DECLARE @fromProductCodeIndicatorChar CHAR(1)
DECLARE @divisionCode CHAR(5)
DECLARE @tsql NVARCHAR(4000)
SELECT @divisionCode = '589'	--Eh, I doubt we'll ever stop using this...
DECLARE @ctr INT
SET @ctr = 1

DECLARE My_BPCursor CURSOR FAST_FORWARD FOR 
SELECT BloodProductGuid, CAST(BloodProductGuid AS VARCHAR(40)), ProductTypeCode, CAST(ProductCodeIndicator AS CHAR(1)) FROM BloodProduct --WHERE BloodProductGuid = 'FAF0BEC7-9A8E-4D67-8A17-003EDD518E1C'


	OPEN My_BPCursor
	FETCH NEXT FROM My_BPCursor INTO @fromBPGuid, @fromBPGuidChar, @fromProductTypeCode, @fromProductCodeIndicatorChar

	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @productModificationCode CHAR(1)
		/******************************************************************************************
		 **********
		 **********      THIS IS BASICALLY spGetTargetProducts - if that changes, update this!!
		 **********      Have to do this because SQL2000 wont let you nest INSERT SELECT EXEC cmds
		 **********            USING SPROC THAT WAS LAST UPDATED --- 07/14/2011
		 **********
		 ******************************************************************************************/
		-- (@productModificationCode = 'T')
		BEGIN
			SET @productModificationCode = 'T'
			INSERT INTO GetTargetProducts_Temp
			SELECT DISTINCT
				BP.BloodProductGUID,
				PT.ComponentClassID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator AS BarcodeType,
				dbo.fnIsProductActive(BP.BloodProductGuid, @divisionCode) AS ProductActiveIndicator,
				BP.ProductCode + ' - ' + BP.ProductShortName AS CodeAndShortName ,
				@divisionCode AS DivisionCode,
		        	BPM.ExpirationDateRule,
				BPM.MethodSelect,
				@productModificationCode
			FROM
				BloodProductModification BPM
			JOIN	dbo.BloodProduct BP ON BPM.ToBloodProductGuid = BP.BloodProductGuid
			JOIN 	dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
			WHERE	BPM.FromBloodProductGuid = @fromBPGuid
		END

		BEGIN
			TRUNCATE TABLE ModificationSubset_Temp	-- CLEAR IT OUT
			SET @productModificationCode = 'P'
			--Passing in Method of -1, means I only have to make one call here...
			INSERT INTO ModificationSubset_Temp
			EXEC dbo.spBloodProductModificationPool @fromBPGuidChar, @productModificationCode, -1

			INSERT INTO GetTargetProducts_Temp
			SELECT DISTINCT
				BP.BloodProductGUID,
				PT.ComponentClassID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator AS BarcodeType,
				dbo.fnIsProductActive(BP.BloodProductGuid, @divisionCode) AS ProductActiveIndicator,
				BP.ProductCode + ' - ' + BP.ProductShortName AS CodeAndShortName,
				@divisionCode AS DivisionCode,
		        		BPM.ExpirationDateRule,
				BPM.MethodSelect,
				@productModificationCode
			FROM
				ModificationSubset_Temp BPM
			
			JOIN	dbo.BloodProduct BP ON BP.ProductCode = BPM.ToProductCode
			JOIN 	dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
			WHERE	BP.OriginalProductTypeCode = BPM.ToProductTypeCode
		END

		BEGIN
			TRUNCATE TABLE ModificationSubset_Temp	-- CLEAR IT OUT
			SET @productModificationCode = 'U'
			--Passing in Method of -1, means I only have to make one call here...
			INSERT INTO ModificationSubset_Temp
			EXEC dbo.spBloodProductModificationPool @fromBPGuidChar, @productModificationCode, -1

			INSERT INTO GetTargetProducts_Temp
			SELECT DISTINCT
				BP.BloodProductGUID,
				PT.ComponentClassID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator AS BarcodeType,
				dbo.fnIsProductActive(BP.BloodProductGuid, @divisionCode) AS ProductActiveIndicator,
				BP.ProductCode + ' - ' + BP.ProductShortName AS CodeAndShortName,
				@divisionCode AS DivisionCode,
		        		BPM.ExpirationDateRule,
				BPM.MethodSelect,
				@productModificationCode
			FROM
				ModificationSubset_Temp BPM
			
			JOIN	dbo.BloodProduct BP ON BP.ProductCode = BPM.ToProductCode
			JOIN 	dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
			WHERE	BP.OriginalProductTypeCode = BPM.ToProductTypeCode
		END

		BEGIN
			TRUNCATE TABLE ModificationSubset_Temp	-- CLEAR IT OUT
			SET @productModificationCode = 'D'
			--Passing in Method of -1, means I only have to make one call here...
			INSERT INTO ModificationSubset_Temp
			EXEC dbo.spSingleBloodProductModification @fromBPGuid, @productModificationCode, -1

			INSERT INTO GetTargetProducts_Temp
			SELECT DISTINCT
				BP.BloodProductGUID,
				PT.ComponentClassID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator AS BarcodeType,
				dbo.fnIsProductActive(BP.BloodProductGuid, @divisionCode) AS ProductActiveIndicator,
				BP.ProductCode + ' - ' + BP.ProductShortName AS CodeAndShortName,
				@divisionCode AS DivisionCode,
		        		BPM.ExpirationDateRule,
				BPM.MethodSelect,
				@productModificationCode
			FROM
				ModificationSubset_Temp BPM
			
			JOIN	dbo.BloodProduct BP ON BP.ProductCode = BPM.ToProductCode
			JOIN 	dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
			WHERE	BP.OriginalProductTypeCode = BPM.ToProductTypeCode
		END 

		BEGIN
			TRUNCATE TABLE ModificationSubset_Temp	-- CLEAR IT OUT
			SET @productModificationCode = 'F'
			--Passing in Method of -1, means I only have to make one call here...
			INSERT INTO ModificationSubset_Temp
			EXEC dbo.spSingleBloodProductModification @fromBPGuid, @productModificationCode, -1

			INSERT INTO GetTargetProducts_Temp
			SELECT DISTINCT
				BP.BloodProductGUID,
				PT.ComponentClassID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator AS BarcodeType,
				dbo.fnIsProductActive(BP.BloodProductGuid, @divisionCode) AS ProductActiveIndicator,
				BP.ProductCode + ' - ' + BP.ProductShortName AS CodeAndShortName,
				@divisionCode AS DivisionCode,
		        		BPM.ExpirationDateRule,
				BPM.MethodSelect,
				@productModificationCode
			FROM
				ModificationSubset_Temp BPM
			
			JOIN	dbo.BloodProduct BP ON BP.ProductCode = BPM.ToProductCode
			JOIN 	dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
			WHERE	BP.OriginalProductTypeCode = BPM.ToProductTypeCode
		END 

		BEGIN
			TRUNCATE TABLE ModificationSubset_Temp	-- CLEAR IT OUT
			SET @productModificationCode = 'I'
			--Passing in Method of -1, means I only have to make one call here...
			INSERT INTO ModificationSubset_Temp
			EXEC dbo.spSingleBloodProductModification @fromBPGuid, @productModificationCode, -1

			INSERT INTO GetTargetProducts_Temp
			SELECT DISTINCT
				BP.BloodProductGUID,
				PT.ComponentClassID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator AS BarcodeType,
				dbo.fnIsProductActive(BP.BloodProductGuid, @divisionCode) AS ProductActiveIndicator,
				BP.ProductCode + ' - ' + BP.ProductShortName AS CodeAndShortName,
				@divisionCode AS DivisionCode,
		        		BPM.ExpirationDateRule,
				BPM.MethodSelect,
				@productModificationCode
			FROM
				ModificationSubset_Temp BPM
			
			JOIN	dbo.BloodProduct BP ON BP.ProductCode = BPM.ToProductCode
			JOIN 	dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
			WHERE	BP.OriginalProductTypeCode = BPM.ToProductTypeCode
		END 

		BEGIN
			TRUNCATE TABLE ModificationSubset_Temp	-- CLEAR IT OUT
			SET @productModificationCode = 'L'
			--Passing in Method of -1, means I only have to make one call here...
			INSERT INTO ModificationSubset_Temp
			EXEC dbo.spSingleBloodProductModification @fromBPGuid, @productModificationCode, -1

			INSERT INTO GetTargetProducts_Temp
			SELECT DISTINCT
				BP.BloodProductGUID,
				PT.ComponentClassID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator AS BarcodeType,
				dbo.fnIsProductActive(BP.BloodProductGuid, @divisionCode) AS ProductActiveIndicator,
				BP.ProductCode + ' - ' + BP.ProductShortName AS CodeAndShortName,
				@divisionCode AS DivisionCode,
		        		BPM.ExpirationDateRule,
				BPM.MethodSelect,
				@productModificationCode
			FROM
				ModificationSubset_Temp BPM
			
			JOIN	dbo.BloodProduct BP ON BP.ProductCode = BPM.ToProductCode
			JOIN 	dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
			WHERE	BP.OriginalProductTypeCode = BPM.ToProductTypeCode
		END 

		BEGIN
			TRUNCATE TABLE ModificationSubset_Temp	-- CLEAR IT OUT
			SET @productModificationCode = 'R'
			--Passing in Method of -1, means I only have to make one call here...
			INSERT INTO ModificationSubset_Temp
			EXEC dbo.spSingleBloodProductModification @fromBPGuid, @productModificationCode, -1

			INSERT INTO GetTargetProducts_Temp
			SELECT DISTINCT
				BP.BloodProductGUID,
				PT.ComponentClassID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator AS BarcodeType,
				dbo.fnIsProductActive(BP.BloodProductGuid, @divisionCode) AS ProductActiveIndicator,
				BP.ProductCode + ' - ' + BP.ProductShortName AS CodeAndShortName,
				@divisionCode AS DivisionCode,
		        		BPM.ExpirationDateRule,
				BPM.MethodSelect,
				@productModificationCode
			FROM
				ModificationSubset_Temp BPM
			
			JOIN	dbo.BloodProduct BP ON BP.ProductCode = BPM.ToProductCode
			JOIN 	dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
			WHERE	BP.OriginalProductTypeCode = BPM.ToProductTypeCode
		END 

		BEGIN
			TRUNCATE TABLE ModificationSubset_Temp	-- CLEAR IT OUT
			SET @productModificationCode = 'S'
			--Passing in Method of -1, means I only have to make one call here...
			INSERT INTO ModificationSubset_Temp
			EXEC dbo.spSingleBloodProductModification @fromBPGuid, @productModificationCode, -1

			INSERT INTO GetTargetProducts_Temp
			SELECT DISTINCT
				BP.BloodProductGUID,
				PT.ComponentClassID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator AS BarcodeType,
				dbo.fnIsProductActive(BP.BloodProductGuid, @divisionCode) AS ProductActiveIndicator,
				BP.ProductCode + ' - ' + BP.ProductShortName AS CodeAndShortName,
				@divisionCode AS DivisionCode,
		        		BPM.ExpirationDateRule,
				BPM.MethodSelect,
				@productModificationCode
			FROM
				ModificationSubset_Temp BPM
			
			JOIN	dbo.BloodProduct BP ON BP.ProductCode = BPM.ToProductCode
			JOIN 	dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
			WHERE	BP.OriginalProductTypeCode = BPM.ToProductTypeCode
		END 

		BEGIN
			TRUNCATE TABLE ModificationSubset_Temp	-- CLEAR IT OUT
			SET @productModificationCode = 'V'
			--Passing in Method of -1, means I only have to make one call here...
			INSERT INTO ModificationSubset_Temp
			EXEC dbo.spSingleBloodProductModification @fromBPGuid, @productModificationCode, -1

			INSERT INTO GetTargetProducts_Temp
			SELECT DISTINCT
				BP.BloodProductGUID,
				PT.ComponentClassID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator AS BarcodeType,
				dbo.fnIsProductActive(BP.BloodProductGuid, @divisionCode) AS ProductActiveIndicator,
				BP.ProductCode + ' - ' + BP.ProductShortName AS CodeAndShortName,
				@divisionCode AS DivisionCode,
		        		BPM.ExpirationDateRule,
				BPM.MethodSelect,
				@productModificationCode
			FROM
				ModificationSubset_Temp BPM
			
			JOIN	dbo.BloodProduct BP ON BP.ProductCode = BPM.ToProductCode
			JOIN 	dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
			WHERE	BP.OriginalProductTypeCode = BPM.ToProductTypeCode
		END 

		BEGIN
			TRUNCATE TABLE ModificationSubset_Temp	-- CLEAR IT OUT
			SET @productModificationCode = 'W'
			--Passing in Method of -1, means I only have to make one call here...
			INSERT INTO ModificationSubset_Temp
			EXEC dbo.spSingleBloodProductModification @fromBPGuid, @productModificationCode, -1

			INSERT INTO GetTargetProducts_Temp
			SELECT DISTINCT
				BP.BloodProductGUID,
				PT.ComponentClassID,
				BP.ProductCode,
				BP.ProductShortName,
				BP.ProductName,
				BP.ProductTypeCode,
				PT.ProductTypeName,
				BP.ProductVolume,
				BP.MaximumStorageTime,
				BP.ProductCodeIndicator AS BarcodeType,
				dbo.fnIsProductActive(BP.BloodProductGuid, @divisionCode) AS ProductActiveIndicator,
				BP.ProductCode + ' - ' + BP.ProductShortName AS CodeAndShortName,
				@divisionCode AS DivisionCode,
		        		BPM.ExpirationDateRule,
				BPM.MethodSelect,
				@productModificationCode
			FROM
				ModificationSubset_Temp BPM
			
			JOIN	dbo.BloodProduct BP ON BP.ProductCode = BPM.ToProductCode
			JOIN 	dbo.ProductType PT ON PT.ProductTypeCode = BP.ProductTypeCode
			WHERE	BP.OriginalProductTypeCode = BPM.ToProductTypeCode
		END 


		--Load all our modifications into the UnitTestModifications table -- this is referenced (aka HardCoded in the UnitTest c# project)
		INSERT INTO UnitTestModifications
		SELECT DISTINCT @fromBPGuidChar, BloodProductGuid, @fromProductTypeCode,  ProductTypeCode,
				@fromProductCodeIndicatorChar, ProductModificationCode, MethodSelect
		FROM GetTargetProducts_Temp

		--Clean the temporary table
		TRUNCATE TABLE GetTargetProducts_Temp

		SET @ctr = @ctr + 1
		FETCH NEXT FROM My_BPCursor INTO @fromBPGuid, @fromBPGuidChar, @fromProductTypeCode, @fromProductCodeIndicatorChar
	END

CLOSE My_BPCursor
DEALLOCATE My_BPCursor

DROP TABLE ModificationSubset_Temp
DROP TABLE GetTargetProducts_Temp

*/
